# [Schema](http://schema.press) #
============

### Welcome to our GitHub Repository

Schema is a light-weight plugin for adding schema.org structured data markup in recommended JSON-LD format automatically to WordPress sites.

### Enhanced Presentation in Search Results

By including structured data appropriate to your content, your site can enhance its search results and presentation.

More information can be found at [scema.press](https://schema.press/).

### What is Schema markup?

Schema markup is code (semantic vocabulary) that you put on your website to help the search engines return more informative results for users. So, Schema is not just for SEO reasons, it’s also for the benefit of the searcher. 

### Schema Key Features 

* Easy to use, set it and forget it, with minimal settings. 
* Enable Schema types at once per post type or post category.
* Valid markup, test it in Google Structured Data Testing Tool.
* Output JSON-LD format, the most recommended by Google.
* Reuse data saved in post meta, which is created by other plugins.
* Extensible, means you can extend its functionality via other plugins, extensions or within your Theme’s functions.php file.

### Plugin Extensions 

* [Schema Review](https://wordpress.org/plugins/schema-review/): Extend Schema functionality by adding review and rating Structured Data functionality for Editors and Authors.
* [Schema Default Image](https://wordpress.org/plugins/schema-default-image/): Add ability to set a default WordPress Featured image for schema.org markup.

### Supported Google/Schema Markups

* [Knowledge Graph](https://developers.google.com/structured-data/customize/overview)
 * [Logos](https://developers.google.com/structured-data/customize/logos)
 * [Company Contact Numbers](https://developers.google.com/structured-data/customize/contact-points)
 * [Social Profile Links](https://developers.google.com/structured-data/customize/social-profiles)

* Style Your Search Results:
 * [Enable Sitelinks Search Box](https://developers.google.com/structured-data/customize/logos)
 * [Show Your Site Name in Search](https://developers.google.com/structured-data/site-name)

### Supported Schema Types
 
* Creative Work
 * [Article](https://schema.org/Article) enabled on Pages
  * [BlogPosting](https://schema.org/BlogPosting) enabled on Posts
  * [NewsArticle](https://schema.org/NewsArticle)
  * [Report](https://schema.org/Report)
  * [ScholarlyArticle](https://schema.org/ScholarlyArticle)
  * [TechArticle](https://schema.org/TechArticle)

* [Blog](https://schema.org/Blog) to markup Blog posts list page.
* [WPHeader](https://schema.org/WPHeader) to markup Web Page Header.
* [WPFooter](https://schema.org/WPFooter) to markup Web Page Footer.
* [BreadcrumbList](https://schema.org/BreadcrumbList) to markup Breadcrumbs.
* [CollectionPage](https://schema.org/CollectionPage) to markup Categories Archives.
* [CollectionPage](https://schema.org/CollectionPage) to markup Tags Archives.
* [AboutPage](https://schema.org/AboutPage) to markup the About page.
* [ContactPage](https://schema.org/ContactPage) to markup the Contact page.
* [Person](https://schema.org/Person) enabled on Author pages
* [VideoObject](https://schema.org/VideoObject) enable automatically on all videos embedded with oEmbed. Supports VideoPress, YouTube, TED, Vimeo, Dailymotion, and Vine.
* [AudioObject](https://schema.org/AudioObject) enable automatically on all audio embedded with oEmbed. Supports SoundCloud, and Mixcloud.


### Supported Plugins

Schema plugin integrates, and play nicely with:

 * Yoast SEO
 * AMP plugin
 * WPRichSnippets
 * The SEO Framework
 * Visual Composer
 * ThirstyAffiliates
 * WooCommerce
 * Easy Digital Downloads (EDD)

### Supported Themes

 * Genesis 2.x 
 * Thesis 2.x
 * Divi

More information and documentation can be found at [scema.press](https://schema.press/).
